<?php
require __DIR__ . '/../../bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if ($input) {
        $pdo = db();
        $pdo->beginTransaction();
        try {
            if (isset($input['seller_address'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('seller_address', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => $input['seller_address']]);
            }
            if (isset($input['whatsapp_number'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('whatsapp_number', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => $input['whatsapp_number']]);
            }
            if (isset($input['locations'])) {
                $loc = $input['locations'];
                if (is_array($loc) || is_object($loc)) {
                    $loc = json_encode($loc, JSON_UNESCAPED_UNICODE);
                }
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('locations', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => $loc]);
            }
            $pdo->commit();
            json_response(['success' => true]);
        } catch (Throwable $e) {
            if ($pdo->inTransaction()) $pdo->rollBack();
            http_response_code(500);
            json_response(['error' => $e->getMessage()]);
        }
    }
    exit;
}

$stmt = db()->query("SELECT k, v FROM site_settings");
$rows = $stmt->fetchAll();

$settings = [];
foreach ($rows as $r) {
    $val = $r['v'];
    // Try to decode JSON if it looks like one (for locations)
    if ($r['k'] === 'locations') {
        $decoded = json_decode($val, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            $val = $decoded;
        } else {
             // Fallback to empty object if invalid
             $val = new stdClass();
        }
    }
    $settings[$r['k']] = $val;
}

// Ensure defaults
$defaults = [
    'seller_address' => '',
    'whatsapp_number' => '',
    'locations' => new stdClass(),
];

$response = array_merge($defaults, $settings);

json_response($response);
