<?php
require __DIR__ . '/../../bootstrap.php';

// Construct Base URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$domainName = $_SERVER['HTTP_HOST'];

// Determine the base path of the application (e.g., /solar_site/public)
// SCRIPT_NAME is like /solar_site/public/api/banners.php
$scriptDir = dirname($_SERVER['SCRIPT_NAME']); // /solar_site/public/api
$basePath = dirname($scriptDir); // /solar_site/public
// Ensure no trailing slash unless it's just /
if ($basePath === '/' || $basePath === '\\') {
    $basePath = '';
}

$baseUrl = $protocol . $domainName . $basePath;

// Clear any previous output to ensure valid JSON
while (ob_get_level()) ob_end_clean();

$now = date('Y-m-d H:i:s');
$showAll = isset($_GET['all']) && $_GET['all'] === '1';

if ($showAll) {
    $sql = "SELECT * FROM site_banners ORDER BY sort_order ASC, id DESC";
    $stmt = db()->prepare($sql);
    $stmt->execute();
} else {
    $sql = "SELECT * FROM site_banners WHERE active = 1 
            AND (start_date IS NULL OR start_date <= :now1) 
            AND (end_date IS NULL OR end_date >= :now2) 
            ORDER BY sort_order ASC, id DESC";
    $stmt = db()->prepare($sql);
    $stmt->execute(['now1' => $now, 'now2' => $now]);
}

$items = $stmt->fetchAll();

$out = array_map(function ($b) use ($baseUrl) {
    $img = (string)$b['image_url'];
    if ($img !== '' && !preg_match('/^https?:\/\//', $img)) {
        // It's a relative path (e.g. uploads/banners/...)
        // Ensure leading slash if missing?
        if ($img[0] !== '/') {
            $img = '/' . $img; // /uploads/...
        }
        $img = $baseUrl . $img;
    }

    return [
        'id' => (int)$b['id'],
        'title' => (string)$b['title'],
        'imageUrl' => $img,
        'imagePath' => (string)$b['image_url'], // Raw path for updates
        'linkUrl' => (string)$b['link_url'], // Keep for backward compat
        'order' => (int)$b['sort_order'],
        'actionType' => $b['action_type'] ?? 'link',
        'actionValue' => $b['action_value'] ?? '',
        'startDate' => $b['start_date'],
        'endDate' => $b['end_date'],
    ];
}, $items);

json_response(['items' => $out]);
