<?php
require __DIR__ . '/../../bootstrap.php';

// Clear buffers
while (ob_get_level()) ob_end_clean();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed'], 405);
}

// Auth Check
$email = $_POST['auth_email'] ?? '';
$password = $_POST['auth_password'] ?? '';

if (empty($email) || empty($password)) {
    json_response(['error' => 'Authentication required'], 401);
}

try {
    $stmt = db()->prepare('SELECT id, password_hash FROM admins WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $admin = $stmt->fetch();

    if (!$admin || !password_verify($password, (string)$admin['password_hash'])) {
        json_response(['error' => 'Unauthorized'], 401);
    }

    // Action
    $action = $_POST['action'] ?? '';
    $uploadDir = __DIR__ . '/../uploads/banners';
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    if ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id > 0) {
             // Delete image
            $stmt = db()->prepare('SELECT image_url FROM site_banners WHERE id = :id');
            $stmt->execute(['id' => $id]);
            $b = $stmt->fetch();
            if ($b && strpos($b['image_url'], 'uploads/') === 0) {
                $f = __DIR__ . '/../' . $b['image_url'];
                if (file_exists($f)) unlink($f);
            }
            
            $stmt = db()->prepare('DELETE FROM site_banners WHERE id = :id');
            $stmt->execute(['id' => $id]);
            json_response(['success' => true]);
        }
        json_response(['error' => 'Invalid ID'], 400);
    }

    if ($action === 'create' || $action === 'update') {
        $id = (int)($_POST['id'] ?? 0);
        $title = $_POST['title'] ?? '';
        $linkUrl = $_POST['link_url'] ?? '';
        $sortOrder = (int)($_POST['order'] ?? 0);
        $active = isset($_POST['active']) && $_POST['active'] == '1' ? 1 : 0;
        $actionType = $_POST['action_type'] ?? 'link';
        $actionValue = $_POST['action_value'] ?? '';
        $startDate = !empty($_POST['start_date']) ? $_POST['start_date'] : null;
        $endDate = !empty($_POST['end_date']) ? $_POST['end_date'] : null;

        // Image
        $imageUrl = $_POST['image_path'] ?? ''; // Use raw path if provided
        if (isset($_FILES['image_file']) && $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {
            $tmpName = $_FILES['image_file']['tmp_name'];
            $name = basename($_FILES['image_file']['name']);
            $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                $newName = uniqid('banner_') . '.' . $ext;
                if (move_uploaded_file($tmpName, $uploadDir . '/' . $newName)) {
                    $imageUrl = 'uploads/banners/' . $newName;
                }
            }
        }

        if ($action === 'create') {
            $stmt = db()->prepare("INSERT INTO site_banners (title, image_url, link_url, sort_order, active, action_type, action_value, start_date, end_date) VALUES (:title, :image_url, :link_url, :sort_order, :active, :action_type, :action_value, :start_date, :end_date)");
            $stmt->execute([
                'title' => $title,
                'image_url' => $imageUrl,
                'link_url' => $linkUrl,
                'sort_order' => $sortOrder,
                'active' => $active,
                'action_type' => $actionType,
                'action_value' => $actionValue,
                'start_date' => $startDate,
                'end_date' => $endDate,
            ]);
            json_response(['success' => true, 'id' => db()->lastInsertId()]);
        } else {
            $stmt = db()->prepare("UPDATE site_banners SET title = :title, image_url = :image_url, link_url = :link_url, sort_order = :sort_order, active = :active, action_type = :action_type, action_value = :action_value, start_date = :start_date, end_date = :end_date WHERE id = :id");
             $stmt->execute([
                'id' => $id,
                'title' => $title,
                'image_url' => $imageUrl,
                'link_url' => $linkUrl,
                'sort_order' => $sortOrder,
                'active' => $active,
                'action_type' => $actionType,
                'action_value' => $actionValue,
                'start_date' => $startDate,
                'end_date' => $endDate,
            ]);
            json_response(['success' => true]);
        }
    }

    json_response(['error' => 'Invalid action'], 400);

} catch (Exception $e) {
    json_response(['error' => $e->getMessage()], 500);
}
