<?php
require __DIR__ . '/../../bootstrap.php';

// Clear buffers
while (ob_get_level()) ob_end_clean();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed'], 405);
}

// Auth Check
$email = $_POST['auth_email'] ?? '';
$password = $_POST['auth_password'] ?? '';

if (empty($email) || empty($password)) {
    json_response(['error' => 'Authentication required'], 401);
}

try {
    $stmt = db()->prepare('SELECT id, password_hash FROM admins WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $admin = $stmt->fetch();

    if (!$admin || !password_verify($password, (string)$admin['password_hash'])) {
        json_response(['error' => 'Unauthorized'], 401);
    }

    // Action
    $action = $_POST['action'] ?? '';
    
    if ($action === 'list') {
        $stmt = db()->query("SELECT * FROM site_dealers ORDER BY sort_order ASC, id DESC");
        $items = $stmt->fetchAll();
        $out = array_map(function ($d) {
            return [
                'id' => (int)$d['id'],
                'name' => (string)$d['name'],
                'sellerName' => (string)($d['seller_name'] ?? ''),
                'phone' => (string)$d['phone'],
                'address' => (string)($d['address'] ?? ''),
                'country' => (string)($d['country'] ?? ''),
                'city' => (string)$d['city'],
                'order' => (int)$d['sort_order'],
                'active' => (bool)$d['active'],
            ];
        }, $items);
        json_response(['items' => $out]);
    }

    if ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id > 0) {
            $stmt = db()->prepare('DELETE FROM site_dealers WHERE id = :id');
            $stmt->execute(['id' => $id]);
            json_response(['success' => true]);
        }
        json_response(['error' => 'Invalid ID'], 400);
    }

    if ($action === 'create' || $action === 'update') {
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $sellerName = trim($_POST['seller_name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $country = trim($_POST['country'] ?? '');
        $city = trim($_POST['city'] ?? '');
        $address = trim($_POST['address'] ?? '');
        $sortOrder = (int)($_POST['order'] ?? 0);
        $active = isset($_POST['active']) && $_POST['active'] == '1' ? 1 : 0;

        if ($action === 'create') {
            $stmt = db()->prepare("INSERT INTO site_dealers (name, seller_name, phone, country, city, address, sort_order, active) VALUES (:name, :seller_name, :phone, :country, :city, :address, :sort_order, :active)");
            $stmt->execute([
                'name' => $name,
                'seller_name' => $sellerName,
                'phone' => $phone,
                'country' => $country,
                'city' => $city,
                'address' => $address,
                'sort_order' => $sortOrder,
                'active' => $active,
            ]);
            json_response(['success' => true, 'id' => db()->lastInsertId()]);
        } else {
            $stmt = db()->prepare("UPDATE site_dealers SET name = :name, seller_name = :seller_name, phone = :phone, country = :country, city = :city, address = :address, sort_order = :sort_order, active = :active WHERE id = :id");
             $stmt->execute([
                'id' => $id,
                'name' => $name,
                'seller_name' => $sellerName,
                'phone' => $phone,
                'country' => $country,
                'city' => $city,
                'address' => $address,
                'sort_order' => $sortOrder,
                'active' => $active,
            ]);
            json_response(['success' => true]);
        }
    }
    
    json_response(['error' => 'Invalid action'], 400);

} catch (Exception $e) {
    json_response(['error' => 'Server Error: ' . $e->getMessage()], 500);
}
