<?php
require __DIR__ . '/../../bootstrap.php';

require_admin('login.php');

$error = null;
$success = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $locationsText = isset($_POST['locations_text']) ? trim((string)$_POST['locations_text']) : '';

    // Parse locations
    $locations = [];
    $lines = explode("\n", $locationsText);
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '') continue;
        
        $parts = explode(':', $line, 2);
        if (count($parts) < 2) continue; // Skip invalid lines
        
        $country = trim($parts[0]);
        if ($country === '') continue;
        
        $citiesRaw = explode(',', $parts[1]);
        $cities = [];
        foreach ($citiesRaw as $c) {
            $c = trim($c);
            if ($c !== '') {
                $cities[] = $c;
            }
        }
        
        if (!empty($cities)) {
            $locations[$country] = $cities;
        }
    }

    $locationsJson = json_encode($locations, JSON_UNESCAPED_UNICODE);

    // Save to DB
    try {
        $pdo = db();
        $pdo->beginTransaction();

        $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES (:k, :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
        $stmt->execute(['k' => 'locations', 'v' => $locationsJson]);

        $pdo->commit();
        $success = 'تم حفظ الإعدادات بنجاح';
    } catch (Throwable $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        $error = 'حدث خطأ أثناء الحفظ: ' . $e->getMessage();
    }
}

// Load settings
$currentSettings = [
    'locations' => [],
];

try {
    $stmt = db()->query("SELECT k, v FROM site_settings");
    while ($row = $stmt->fetch()) {
        if ($row['k'] === 'locations') {
            $decoded = json_decode($row['v'], true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                $currentSettings['locations'] = $decoded;
            }
        }
    }
} catch (Throwable $e) {
    // Ignore
}

// Convert locations to text for textarea
$locationsTextVal = '';
foreach ($currentSettings['locations'] as $country => $cities) {
    $locationsTextVal .= $country . ': ' . implode(', ', $cities) . "\n";
}
$locationsTextVal = trim($locationsTextVal);

?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - إدارة المواقع</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:800px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    label{display:block;margin:10px 0 6px;font-weight:700}
    input, textarea{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px;box-sizing:border-box}
    button{padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    .alert{padding:12px;border-radius:8px;margin-bottom:12px}
    .alert.error{background:#fee2e2;color:#991b1b}
    .alert.success{background:#dcfce7;color:#166534}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="banners.php">البنرات</a>
          <a class="btn" href="dealers.php">التجار</a>
          <a class="btn" href="settings.php">الإعدادات</a>
          <a class="btn" href="profile.php">حسابي</a>
          <a class="btn" href="../index.php">الموقع</a>
          <a class="btn" href="logout.php" style="background:#b00020">خروج</a>
        </div>
      </div>
    </div>
  </header>

  <div class="container">
    <div style="margin-bottom:20px;display:flex;justify-content:space-between;align-items:center">
      <h1 style="margin:0;font-size:24px">إدارة المواقع (الدول والمدن)</h1>
    </div>

    <?php if ($error): ?><div class="alert error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
    <?php if ($success): ?><div class="alert success"><?php echo htmlspecialchars($success); ?></div><?php endif; ?>

    <div class="card">
      <form method="post">
        
        <label>قائمة الدول والمدن</label>
        <div style="font-size:13px;color:#666;margin-bottom:6px">
          أدخل كل دولة في سطر، متبوعة بنقطتين ثم المدن مفصولة بفاصلة.<br>
          مثال:<br>
          <code>السعودية: الرياض, جدة, الدمام</code><br>
          <code>مصر: القاهرة, الإسكندرية</code>
        </div>
        <textarea name="locations_text" rows="12" dir="ltr" style="text-align:right"><?php echo htmlspecialchars($locationsTextVal); ?></textarea>

        <div style="margin-top:20px;text-align:left">
          <button type="submit">حفظ التغييرات</button>
        </div>
      </form>
    </div>
  </div>
</body>
</html>
