<?php
require __DIR__ . '/../../bootstrap.php';

require_admin('login.php');

$error = null;

// Fetch Locations for Dropdowns
$locations = [];
try {
    $stmt = db()->query("SELECT v FROM site_settings WHERE k = 'locations' LIMIT 1");
    if ($row = $stmt->fetch()) {
        $decoded = json_decode($row['v'], true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            $locations = $decoded;
        }
    }
} catch (Throwable $e) {}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? (string)$_POST['action'] : '';

    if ($action === 'save') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        $name = isset($_POST['name']) ? trim((string)$_POST['name']) : ''; // Store Name
        $sellerName = isset($_POST['seller_name']) ? trim((string)$_POST['seller_name']) : '';
        $phone = isset($_POST['phone']) ? trim((string)$_POST['phone']) : ''; // WhatsApp
        $address = isset($_POST['address']) ? trim((string)$_POST['address']) : '';
        $country = isset($_POST['country']) ? trim((string)$_POST['country']) : '';
        $city = isset($_POST['city']) ? trim((string)$_POST['city']) : '';
        $sortOrder = isset($_POST['sort_order']) ? (int)$_POST['sort_order'] : 0;
        $active = isset($_POST['active']) ? 1 : 0;

        try {
            if ($id <= 0) {
                $stmt = db()->prepare("INSERT INTO site_dealers (name, seller_name, phone, address, country, city, sort_order, active) VALUES (:name, :seller_name, :phone, :address, :country, :city, :sort_order, :active)");
                $stmt->execute([
                    'name' => $name,
                    'seller_name' => $sellerName,
                    'phone' => $phone,
                    'address' => $address,
                    'country' => $country,
                    'city' => $city,
                    'sort_order' => $sortOrder,
                    'active' => $active,
                ]);
            } else {
                $stmt = db()->prepare("UPDATE site_dealers SET name = :name, seller_name = :seller_name, phone = :phone, address = :address, country = :country, city = :city, sort_order = :sort_order, active = :active WHERE id = :id");
                $stmt->execute([
                    'id' => $id,
                    'name' => $name,
                    'seller_name' => $sellerName,
                    'phone' => $phone,
                    'address' => $address,
                    'country' => $country,
                    'city' => $city,
                    'sort_order' => $sortOrder,
                    'active' => $active,
                ]);
            }
            redirect('dealers.php');
        } catch (Throwable $e) {
            $error = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
        }
    }

    if ($action === 'delete') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        if ($id > 0) {
            $stmt = db()->prepare('DELETE FROM site_dealers WHERE id = :id');
            $stmt->execute(['id' => $id]);
        }
        redirect('dealers.php');
    }
}

$items = [];
$dbNeedsUpdate = false;
try {
    $itemsStmt = db()->query("SELECT * FROM site_dealers ORDER BY country ASC, city ASC, sort_order ASC, id DESC");
    $items = $itemsStmt->fetchAll();
} catch (Throwable $e) {
    $error = 'خطأ في جلب البيانات: ' . $e->getMessage();
    if (strpos($e->getMessage(), 'Unknown column') !== false) {
        $dbNeedsUpdate = true;
    }
}

$editId = isset($_GET['edit']) ? (int)$_GET['edit'] : 0;
$edit = null;
if ($editId > 0) {
    try {
        $stmt = db()->prepare('SELECT * FROM site_dealers WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $editId]);
        $edit = $stmt->fetch();
    } catch (Throwable $e) {
        $error = 'خطأ في جلب بيانات التاجر: ' . $e->getMessage();
    }
}

// Prepare JSON for JS
$locationsJson = json_encode($locations);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - التجار</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    .grid{display:grid;grid-template-columns:1fr;gap:14px}
    @media (min-width:900px){.grid{grid-template-columns:.9fr 1.1fr}}
    label{display:block;margin:10px 0 6px;font-weight:700}
    input, select, textarea{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px;box-sizing:border-box}
    button{padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right;vertical-align:top}
    .muted{color:#666;font-size:0.9em}
    .row-actions{display:flex;gap:8px;align-items:center}
    .danger{background:#b00020}
    .alert{padding:12px;border-radius:8px;margin-bottom:12px;background:#fee2e2;color:#991b1b}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="banners.php">البنرات</a>
          <a class="btn" href="dealers.php">التجار</a>
          <a class="btn" href="settings.php">الإعدادات</a>
          <a class="btn" href="profile.php">حسابي</a>
          <a class="btn" href="../index.php">الموقع</a>
          <a class="btn" href="logout.php" style="background:#b00020">خروج</a>
        </div>
      </div>
    </div>
  </header>

  <div class="container">
    <div style="margin-bottom:20px;display:flex;justify-content:space-between;align-items:center">
      <h1 style="margin:0;font-size:24px">إدارة التجار</h1>
      <?php if($edit): ?>
        <a href="dealers.php" class="btn" style="background:#666">إلغاء التعديل</a>
      <?php endif; ?>
    </div>

    <?php if ($error): ?><div class="alert"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

    <div class="grid">
      <!-- Form -->
      <div class="card">
        <h2 style="margin-top:0"><?php echo $edit ? 'تعديل تاجر' : 'إضافة تاجر جديد'; ?></h2>
        <form method="post">
          <input type="hidden" name="action" value="save">
          <?php if($edit): ?><input type="hidden" name="id" value="<?php echo $edit['id']; ?>"><?php endif; ?>

          <label>اسم المتجر</label>
          <input type="text" name="name" value="<?php echo htmlspecialchars($edit['name'] ?? ''); ?>" required>

          <label>اسم البائع</label>
          <input type="text" name="seller_name" value="<?php echo htmlspecialchars($edit['seller_name'] ?? ''); ?>" required>

          <label>رقم واتساب البائع</label>
          <input type="text" name="phone" value="<?php echo htmlspecialchars($edit['phone'] ?? ''); ?>" required dir="ltr" style="text-align:right">

          <label>الدولة</label>
          <select name="country" id="countrySelect" required>
              <option value="">اختر الدولة...</option>
              <?php foreach($locations as $country => $cities): ?>
                  <option value="<?php echo htmlspecialchars($country); ?>" <?php if(($edit['country'] ?? '') === $country) echo 'selected'; ?>>
                      <?php echo htmlspecialchars($country); ?>
                  </option>
              <?php endforeach; ?>
          </select>

          <label>المدينة</label>
          <select name="city" id="citySelect" required>
              <option value="">اختر الدولة أولاً...</option>
          </select>

          <label>العنوان بالتفصيل</label>
          <textarea name="address" rows="3"><?php echo htmlspecialchars($edit['address'] ?? ''); ?></textarea>

          <label>الترتيب</label>
          <input type="number" name="sort_order" value="<?php echo $edit['sort_order'] ?? 0; ?>">

          <label>
            <input type="checkbox" name="active" style="width:auto" <?php if(!isset($edit) || $edit['active']) echo 'checked'; ?>>
            نشط (يظهر في التطبيق)
          </label>

          <div style="margin-top:20px">
            <button type="submit"><?php echo $edit ? 'حفظ التعديلات' : 'إضافة'; ?></button>
          </div>
        </form>
      </div>

      <!-- List -->
      <div class="card">
        <h2 style="margin-top:0">قائمة التجار</h2>
        <?php if(empty($items)): ?>
          <p class="muted">لا يوجد تجار مضافين بعد.</p>
        <?php else: ?>
          <table>
            <thead>
              <tr>
                <th>المتجر / البائع</th>
                <th>الموقع</th>
                <th>الحالة</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($items as $item): ?>
                <tr>
                  <td>
                    <strong><?php echo htmlspecialchars($item['name']); ?></strong><br>
                    <span class="muted"><?php echo htmlspecialchars($item['seller_name'] ?? ''); ?></span>
                  </td>
                  <td>
                    <?php echo htmlspecialchars($item['country'] ?? ''); ?> - <?php echo htmlspecialchars($item['city']); ?>
                  </td>
                  <td>
                    <?php if($item['active']): ?>
                      <span style="color:green">نشط</span>
                    <?php else: ?>
                      <span style="color:red">غير نشط</span>
                    <?php endif; ?>
                  </td>
                  <td>
                    <div class="row-actions">
                      <a href="?edit=<?php echo $item['id']; ?>" class="btn" style="padding:4px 8px;font-size:12px">تعديل</a>
                      <form method="post" onsubmit="return confirm('هل أنت متأكد من الحذف؟');" style="display:inline">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                        <button type="submit" class="danger" style="padding:4px 8px;font-size:12px">حذف</button>
                      </form>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <script>
    const locations = <?php echo $locationsJson; ?>;
    const countrySelect = document.getElementById('countrySelect');
    const citySelect = document.getElementById('citySelect');
    const selectedCity = "<?php echo $edit['city'] ?? ''; ?>";

    function updateCities() {
        const country = countrySelect.value;
        citySelect.innerHTML = '<option value="">اختر المدينة...</option>';
        
        if (country && locations[country]) {
            locations[country].forEach(city => {
                const opt = document.createElement('option');
                opt.value = city;
                opt.textContent = city;
                if (city === selectedCity) {
                    opt.selected = true;
                }
                citySelect.appendChild(opt);
            });
        }
    }

    countrySelect.addEventListener('change', () => {
        citySelect.value = ''; // Reset selection on change
        updateCities();
    });

    // Initial load
    if (countrySelect.value) {
        updateCities();
    }
  </script>
</body>
</html>
