<?php
require __DIR__ . '/../../bootstrap.php';

require_admin('login.php');

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? (string)$_POST['action'] : '';

    if ($action === 'save') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        $name = isset($_POST['name']) ? trim((string)$_POST['name']) : '';
        $phone = isset($_POST['phone']) ? trim((string)$_POST['phone']) : '';
        $city = isset($_POST['city']) ? trim((string)$_POST['city']) : '';
        $sortOrder = isset($_POST['sort_order']) ? (int)$_POST['sort_order'] : 0;
        $active = isset($_POST['active']) ? 1 : 0;

        if ($id <= 0) {
            $stmt = db()->prepare("INSERT INTO site_dealers (name, phone, city, sort_order, active) VALUES (:name, :phone, :city, :sort_order, :active)");
            $stmt->execute([
                'name' => $name,
                'phone' => $phone,
                'city' => $city,
                'sort_order' => $sortOrder,
                'active' => $active,
            ]);
        } else {
            $stmt = db()->prepare("UPDATE site_dealers SET name = :name, phone = :phone, city = :city, sort_order = :sort_order, active = :active WHERE id = :id");
            $stmt->execute([
                'id' => $id,
                'name' => $name,
                'phone' => $phone,
                'city' => $city,
                'sort_order' => $sortOrder,
                'active' => $active,
            ]);
        }

        redirect('dealers.php');
    }

    if ($action === 'delete') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        if ($id > 0) {
            $stmt = db()->prepare('DELETE FROM site_dealers WHERE id = :id');
            $stmt->execute(['id' => $id]);
        }
        redirect('dealers.php');
    }

    $error = 'طلب غير معروف';
}

$itemsStmt = db()->query("SELECT id, name, phone, city, sort_order, active FROM site_dealers ORDER BY city ASC, sort_order ASC, id DESC");
$items = $itemsStmt->fetchAll();

$editId = isset($_GET['edit']) ? (int)$_GET['edit'] : 0;
$edit = null;
if ($editId > 0) {
    $stmt = db()->prepare('SELECT * FROM site_dealers WHERE id = :id LIMIT 1');
    $stmt->execute(['id' => $editId]);
    $edit = $stmt->fetch();
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - التجار</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    .grid{display:grid;grid-template-columns:1fr;gap:14px}
    @media (min-width:900px){.grid{grid-template-columns:.9fr 1.1fr}}
    label{display:block;margin:10px 0 6px;font-weight:700}
    input{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px}
    button{padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right;vertical-align:top}
    .muted{color:#666}
    .row-actions{display:flex;gap:8px;align-items:center}
    .danger{background:#b00020}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="banners.php">البنرات</a>
          <a class="btn" href="../index.php">الموقع</a>
          <a class="btn" href="logout.php">خروج</a>
        </div>
      </div>
    </div>
  </header>

  <main class="container">
    <?php if ($error !== null): ?>
      <div class="card" style="margin-bottom:14px;color:#b00020;font-weight:700"><?php echo h($error); ?></div>
    <?php endif; ?>
    <div class="grid">
      <section class="card">
        <h2 style="margin:0 0 10px"><?php echo $edit ? 'تعديل تاجر' : 'إضافة تاجر'; ?></h2>
        <form method="post">
          <input type="hidden" name="action" value="save">
          <input type="hidden" name="id" value="<?php echo $edit ? (int)$edit['id'] : 0; ?>">

          <label for="name">اسم التاجر</label>
          <input id="name" name="name" value="<?php echo $edit ? h((string)$edit['name']) : ''; ?>">

          <label for="phone">رقم الهاتف</label>
          <input id="phone" name="phone" value="<?php echo $edit ? h((string)$edit['phone']) : ''; ?>">

          <label for="city">المدينة</label>
          <input id="city" name="city" value="<?php echo $edit ? h((string)$edit['city']) : ''; ?>">

          <label for="sort_order">الترتيب</label>
          <input id="sort_order" name="sort_order" type="number" value="<?php echo $edit ? (int)$edit['sort_order'] : 0; ?>">

          <label style="display:flex;gap:10px;align-items:center;margin-top:12px">
            <input type="checkbox" name="active" <?php echo $edit ? ((int)$edit['active'] === 1 ? 'checked' : '') : 'checked'; ?> style="width:auto">
            <span style="font-weight:700">مفعل</span>
          </label>

          <div style="height:12px"></div>
          <div style="display:flex;gap:10px;align-items:center;justify-content:flex-start">
            <button type="submit">حفظ</button>
            <?php if ($edit): ?>
              <a class="btn" href="dealers.php" style="background:#666">إلغاء</a>
            <?php endif; ?>
          </div>
        </form>
      </section>

      <section class="card">
        <h2 style="margin:0 0 10px">قائمة التجار</h2>
        <?php if (count($items) === 0): ?>
          <div class="muted">لا توجد بيانات تجار</div>
        <?php else: ?>
          <table>
            <thead>
              <tr>
                <th>الاسم</th>
                <th>المدينة</th>
                <th>الهاتف</th>
                <th>الحالة</th>
                <th>إجراءات</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($items as $d): ?>
              <tr>
                <td style="font-weight:700"><?php echo h((string)$d['name']); ?></td>
                <td><?php echo h((string)$d['city']); ?></td>
                <td><?php echo h((string)$d['phone']); ?></td>
                <td><?php echo ((int)$d['active'] === 1) ? 'مفعل' : 'موقوف'; ?></td>
                <td>
                  <div class="row-actions">
                    <a class="btn" href="dealers.php?edit=<?php echo (int)$d['id']; ?>" style="background:#2c7be5">تعديل</a>
                    <form method="post" onsubmit="return confirm('حذف التاجر؟');" style="display:inline">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?php echo (int)$d['id']; ?>">
                      <button class="danger" type="submit">حذف</button>
                    </form>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </section>
    </div>
  </main>
</body>
</html>
